% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{neonatal_intubation_times_df}
\alias{neonatal_intubation_times_df}
\title{Neonatal Intubation Simulation}
\format{
A data frame with 37 observations and 7 variables:
\describe{
  \item{id}{Participant ID (integer)}
  \item{deci_intub}{Time to decision to intubate (seconds) (integer)}
  \item{stop_ventil}{Time to stop ventilation (seconds) (integer)}
  \item{blade_in}{Time to insert laryngoscope blade (seconds) (integer)}
  \item{insert_tube}{Time to insert endotracheal tube (seconds) (integer)}
  \item{blade_out}{Time to remove laryngoscope blade (seconds) (integer)}
  \item{restart_ventil}{Time to restart ventilation (seconds) (integer)}
}
}
\source{
Data taken from the ViSiElse package version 1.2.2
}
\usage{
data(neonatal_intubation_times_df)
}
\description{
This dataset, neonatal_intubation_times_df, is a data frame containing execution times (in seconds)
for specific actions performed by 37 midwife students during a high-fidelity neonatal resuscitation
simulation. The simulation was video recorded, and each critical action in the intubation process
was tagged for timing analysis.
}
\details{
The dataset name has been kept as 'neonatal_intubation_times_df' to avoid confusion
with other datasets in the R ecosystem. This naming convention helps distinguish
this dataset as part of the PulmoDataSets package. The suffix 'df' indicates
that this is a data frame object. The original content has not been modified
in any way.
}
