% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{chicago_pollution_df}
\alias{chicago_pollution_df}
\title{Chicago Mortality and Pollution}
\format{
A data frame with 5114 observations and 14 variables:
\describe{
  \item{date}{Date (Date object)}
  \item{time}{Time index (integer vector)}
  \item{year}{Year (numeric vector)}
  \item{month}{Month (numeric vector)}
  \item{doy}{Day of year (integer vector)}
  \item{dow}{Day of week (factor with 7 levels)}
  \item{death}{All-cause mortality count (integer vector)}
  \item{cvd}{Cardiovascular mortality count (integer vector)}
  \item{resp}{Respiratory mortality count (integer vector)}
  \item{temp}{Temperature (numeric vector)}
  \item{dptp}{Dew point temperature (numeric vector)}
  \item{rhum}{Relative humidity (numeric vector)}
  \item{pm10}{PM10 pollution level (numeric vector)}
  \item{o3}{Ozone level (numeric vector)}
}
}
\source{
Data taken from the dlnm package version 2.4.10
}
\usage{
data(chicago_pollution_df)
}
\description{
This dataset, chicago_pollution_df, is a data frame containing daily mortality, weather,
and pollution data for Chicago from 1987 to 2000 from the National Morbidity, Mortality
and Air Pollution Study (NMMAPS). It includes all-cause mortality, cardiovascular and
respiratory deaths, temperature, humidity, and pollution levels (PM10 and ozone).
}
\details{
The dataset name has been kept as 'chicago_pollution_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
PulmoDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a standard data frame. The original content has not been modified
in any way.
}
