% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneAnnotationSearch.R
\name{geneAnnotationSearch}
\alias{geneAnnotationSearch}
\title{Search for gene annotations on classified contigs/chunks}
\usage{
geneAnnotationSearch(
  ProActiveResults,
  pileup,
  gffTSV,
  geneOrProduct,
  keyWords,
  inGapOrElev = FALSE,
  bpRange = 0,
  elevFilter,
  saveFilesTo,
  verbose = TRUE
)
}
\arguments{
\item{ProActiveResults}{The output from `ProActive()`.}

\item{pileup}{A .txt file containing mapped sequencing read coverages averaged over
100 bp windows/bins.}

\item{gffTSV}{A .gff file (TSV) containing gene predictions associated with the .fasta
file used to generate the pileup.}

\item{geneOrProduct}{"gene" or "product". Search for keyWords associated with genes or gene products.}

\item{keyWords}{The keyWord(s) to search for. Case independent. Searches will return the string
that contains the matching keyWord. KeyWord(s) must be in quotes, comma-separated, and surrounded by
c() i.e( c("antibiotic", "resistance", "drug") )}

\item{inGapOrElev}{TRUE or FALSE. If TRUE, only search for gene-annotations in
the gap/elevation region of the pattern-match. Default is FALSE (i.e search the
entire contig/chunk for the gene annotation key-words)}

\item{bpRange}{If `inGapOrElev` = TRUE, the user may specify the region (in base pairs) that should
be searched to the left and right of the gap/elevation region. Default is 0.}

\item{elevFilter}{Optional, only plot results with pattern-matches that achieved an
elevation ratio (max/min) greater than the specified values. Default is no filter.}

\item{saveFilesTo}{Optional, Provide a path to the directory you wish to save
output to. A folder will be made within the provided directory to store
results.}

\item{verbose}{TRUE or FALSE. Print progress messages to console. Default is TRUE.}
}
\value{
list of ggplot objects
}
\description{
Search contigs classified with ProActive for gene-annotations that match a provided
key-word(s). Outputs read coverage plots for contigs/chunks with matching annotations.
}
\examples{
geneAnnotMatches <- geneAnnotationSearch(sampleMetagenomeResults, sampleMetagenomePileup,
                                          sampleMetagenomegffTSV, geneOrProduct="product",
                                          keyWords=c("toxin", "drug", "resistance", "phage"))
}
