% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_A.R
\name{matrix_A}
\alias{matrix_A}
\alias{mt3_matrix_A}
\alias{mt4_matrix_A}
\title{From derivatives of MGF to derivatives of CGF.}
\usage{
mt3_matrix_A(t)

mt4_matrix_A(t)
}
\arguments{
\item{t}{vector of \eqn{\mathbb{R}^p}}
}
\value{
\code{mt3_matrix_A} returns coefficient matrix relating to the use
of third derivatives.

\code{mt4_matrix_A} returns coefficient matrix relating to the
use of fourth derivatives.
}
\description{
Taylor expansion implies that vectors of derivatives of
\eqn{\log(\hat{M}_X(t))} can be approximated
by a linear combination of vectors of derivatives of \eqn{\hat{M}_X(t)}.
\code{matrix_A} results the corresponding
linear combinations.
}
\examples{
p <- 3
t <- rep(.2, p)
A3 <- mt3_matrix_A(t)
dim(A3)
A3[1:5, 1:5]
A4 <- mt4_matrix_A(t)
dim(A4)
A4[1:5, 1:5]
}
