% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Multi_Uni.R
\name{Independent_transformation}
\alias{Independent_transformation}
\alias{Multi.to.Uni}
\title{Transformation to Independent Univariate Sample}
\usage{
Multi.to.Uni(x)
}
\arguments{
\item{x}{multivariate data matrix}
}
\value{
Data frame contains univariate data and
the index from multivariate data.
}
\description{
Leave-one-out method gives approximately independent sample of
standard multivariate normal distribution,
which then produces sample of standard univariate normal distribution.
}
\details{
Let \eqn{\bar{X}_{-k} } and \eqn{S_{-k}} are the sample mean sample variance
covariance matrix obtained by using all but \eqn{k^{th}} data point. Then
\eqn{S_{-k}^{-1/2} (X_k - \bar{X}_{-k}) , k = 1,... n} are approximately
independently distributed as \eqn{N_p(0, I)}. Thus all \eqn{n \times p}
entries in the data matrix so constructed can be treated as
univariate samples of size \eqn{n \times p} from \eqn{N(0, 1)}.
}
\examples{
set.seed(1)
x <- MASS::mvrnorm(100, mu = rep(0, 5), diag(5))
df <- Multi.to.Uni(x)
qqnorm(df$x.new); abline(0, 1)
}
