% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbSharpeRatio.R
\name{ProbSharpeRatio}
\alias{ProbSharpeRatio}
\title{Probabilistic Sharpe Ratio}
\usage{
ProbSharpeRatio(
  R = NULL,
  Rf = 0,
  refSR,
  p = 0.95,
  weights = NULL,
  n = NULL,
  sr = NULL,
  sk = NULL,
  kr = NULL,
  ignore_skewness = FALSE,
  ignore_kurtosis = TRUE
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of the returns input}

\item{Rf}{the risk free rate}

\item{refSR}{a single value or a vector when R is multicolumn. It defines the reference Sharpe Ratio and should be in the same periodicity as the returns (non-annualized).}

\item{p}{the confidence level}

\item{weights}{(if R is multicolumn and the underlying assets form a portfolio) the portfolio weights}

\item{n}{(if R is NULL) the track record length of the returns}

\item{sr}{(if R is NULL) the sharpe ratio of the returns}

\item{sk}{(if R is NULL) the skewness of the returns}

\item{kr}{(if R is NULL) the kurtosis of the returns}

\item{ignore_skewness}{If TRUE, it ignores the effects of skewness in the calculations}

\item{ignore_kurtosis}{If TRUE, it ignores the effects of kurtosis in the calculations}
}
\value{
A list containing the below
\itemize{  \item The probability that the observed Sharpe Ratio is higher than the reference one 
 \item The p-level confidence interval of the Sharpe Ratio}
}
\description{
Given a predefined benchmark Sharpe ratio,the observed Sharpe Ratio 
can be expressed in probabilistic terms known as the Probabilistic 
Sharpe Ratio. PSR provides an adjusted estimate of SR, by removing the inflationary effect caused by short series with skewed and/or fat-tailed returns and
is defined as the probability of the observed sharpe ratio being higher than the reference sharpe ratio.
}
\examples{

data(edhec)
ProbSharpeRatio(edhec[,1],refSR = 0.23) 
ProbSharpeRatio(refSR = 1/12^0.5,Rf = 0,p=0.95,sr = 2/12^0.5,sk=-0.72,kr=5.78,n=59)

### Higher moments are data intensive, kurtosis shouldn't be used for short timeseries
ProbSharpeRatio(edhec[,1:2],refSR = c(0.28,0.24), ignore_skewness = FALSE, ignore_kurtosis = FALSE)
ProbSharpeRatio(edhec[,1:2],refSR = c(0.28,0.24), ignore_skewness = FALSE, ignore_kurtosis = TRUE)
ProbSharpeRatio(edhec[,1:2],refSR = c(0.28,0.24), ignore_skewness = TRUE, ignore_kurtosis = TRUE)

ProbSharpeRatio(edhec[,1:2],refSR = 0.26,weights = c(0.5,0.5), 
                ignore_skewness = FALSE, ignore_kurtosis = FALSE)

}
\references{
Marcos Lopez de Prado. 2018. Advances in Financial Machine Learning (1st ed.). Wiley Publishing.
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>, Pulkit Mehrotra
}
