% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSAboot.R
\name{getPSAbootMethods}
\alias{getPSAbootMethods}
\alias{PSAboot}
\title{Returns a vector with the default methods used by `PSAboot()`.}
\usage{
getPSAbootMethods()

PSAboot(
  Tr,
  Y,
  X,
  M = 100,
  formu = as.formula(paste0("treat ~ ", paste0(names(X), collapse = " + "))),
  control.ratio = 5,
  control.sample.size = min(control.ratio * min(table(Tr)), max(table(Tr))),
  control.replace = TRUE,
  treated.sample.size = min(table(Tr)),
  treated.replace = TRUE,
  methods = getPSAbootMethods(),
  parallel = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{Tr}{numeric (0 or 1) or logical vector of treatment indicators.}

\item{Y}{vector of outcome variable}

\item{X}{matrix or data frame of covariates used to estimate the propensity scores.}

\item{M}{number of bootstrap samples to generate.}

\item{formu}{formula used for estimating propensity scores. The default is to use
all covariates in \code{X}.}

\item{control.ratio}{the ratio of control units to sample relative to the treatment units.}

\item{control.sample.size}{the size of each bootstrap sample of control units.}

\item{control.replace}{whether to use replacement when sampling from control units.}

\item{treated.sample.size}{the size of each bootstrap sample of treatment units. The
default uses all treatment units for each bootstrap sample.}

\item{treated.replace}{whether to use replacement when sampling from treated units.}

\item{methods}{a named vector of functions for each PSA method to use.}

\item{parallel}{whether to run the bootstrap samples in parallel.}

\item{seed}{random seed. Each iteration, i, will use a seed of \code{seed + i}.}

\item{...}{other parameters passed to `[Match()]` and `[psa.strata()]`}
}
\value{
a vector of methods for use by `PSAboot()`

a list with following elements:
		  \describe{
		  \item{overall.summary}{Data frame with the results using the complete
		                         dataset (i.e. unbootstrapped results).}
		  \item{overall.details}{Objects returned from each method for complete dataset.}
		  \item{pooled.summary}{Data frame with results of each bootstrap sample.}
		  \item{pooled.details}{List of objects returned from each method for each 
		        bootstrap sample.}
		  \item{control.sample.size}{sample size used for control units.}
		  \item{treated.sample.size}{sample size used for treated units.}
		  \item{control.replace}{whether control units were sampled with replacement.}
		  \item{treated.replace}{whether treated units were sampled with replacement.}
		  \item{Tr}{vector of treatment assignment.}
		  \item{Y}{vector out outcome.}
		  \item{X}{matrix or data frame of covariates.}
		  \item{M}{number of bootstrap samples.}
		  }
}
\description{
The current default methods are:

Bootstrapping has become a popular resampling method for estimating sampling
distributions. And propensity score analysis (PSA) has become popular for estimating
causal effects in observational studies. This function implements bootstrapping
specifically for PSA. Like typical bootstrapping methods, this function estimates
treatment effects for M random samples. However, unlike typical bootstrap methods,
this function allows for separate sample sizes for treatment and control units.
That is, under certain circumstances (e.g. when the ratio of treatment-to-control
units is large) bootstrapping only the control units may be desirable. Additionally,
this function provides a framework to use multiple PSA methods for each bootstrap
sample.
}
\details{


Be sure to check the `PSAboot` vignette for more details. The *Applied Propensity Score
Analysis with R* online book also has some worked examples: https://psa.bryer.org
}
\examples{
\donttest{
library(PSAboot)
data(pisa.psa.cols)
data(pisausa)
bm.usa <- PSAboot(Tr = as.integer(pisausa$PUBPRIV) - 1,
    Y = pisausa$Math,
    X = pisausa[,pisa.psa.cols],
    control.ratio = 5, M = 100, seed = 2112)

}
}
\seealso{
getPSAbootMethods
}
