% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{plot.PlateObj}
\alias{plot.PlateObj}
\title{Plotting 96 well plate}
\usage{
\method{plot}{PlateObj}(
  x,
  color = "conc",
  Instrument = "",
  caption = "",
  label_size = 1,
  transform_dil = FALSE,
  watermark = "auto",
  path = NULL,
  ...
)
}
\arguments{
\item{x}{PlateObj}

\item{color}{character. Coloring variable. Either "conc", "time", "factor", "samples", "dosage"}

\item{Instrument}{A string placed at subtitle}

\item{caption}{A string place at plate caption}

\item{label_size}{numeric. Size of the label. Default is 15}

\item{transform_dil}{logical. If TRUE, transform the dilution factor to the label}

\item{watermark}{character. If "auto", a watermark is added to the plot. If "none", no watermark is added. Default is "auto"}

\item{path}{Default is NULL, if not null, must be a path to save plate image}

\item{...}{additional arguments passed to ggplot2::ggsave}
}
\value{
ggplot object
}
\description{
Plotting 96 well plate
}
\examples{
plate <- generate_96("new_plate", "C", 11) |>
  add_blank(IS = FALSE, analyte = FALSE) |>
  add_blank(IS = TRUE, analyte = FALSE) |>
  add_samples(c(
    "RD_per1", "RD_in1", "RD_T30", "RD_T60", "RD_T90", "RD_per2", "RD_in2",
    "EE_in0", "EE_T30", "EE_in30", "EE_T60", "EE_in60", "EE_T90", "EE_in90"
  ))
plot(plate)
}
