% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_auc_analytic.R
\name{calc_auc_analytic}
\alias{calc_auc_analytic}
\title{Convenience function to calculate the AUC based on PK model parameters at
any given moment, for linear iv models.}
\usage{
calc_auc_analytic(
  f = c("1cmt_iv_infusion", "2cmt_iv_infusion", "3cmt_iv_infusion", "1cmt_iv_bolus",
    "2cmt_iv_bolus", "3cmt_iv_bolus"),
  parameters,
  regimen = NULL,
  dose = NULL,
  interval = NULL,
  t_inf = NULL,
  t_obs = c(0, 24, 48, 72),
  ...
)
}
\arguments{
\item{f}{analytic model to use, show available models using \code{advan()}}

\item{parameters}{list of parameter estimates. Requires CL/V for
1-compartment models, CL/V/Q/V2 for 2-compartment models, and CL/V/Q/V2/Q2/V3
for 3-compartment models.}

\item{regimen}{PKPDsim regimen created using \code{new_regimen}. Not required,
regimen can also be specified using \code{dose}, \code{interval}, and \code{t_inf}.}

\item{dose}{dosing amount for regimen (single value). Only used if no
\code{regimen} supplied.}

\item{interval}{dosing interval for regimen (single value). Only used if no
. \code{regimen} supplied.}

\item{t_inf}{infusion length for regimen (single value). Only used if no
\code{regimen} supplied.}

\item{t_obs}{vector of observation times for AUC}

\item{...}{optional arguments passed to \code{advanc_create_data()}}
}
\value{
a data.frame with \code{t} and \code{auc}
}
\description{
Convenience function to calculate the AUC based on PK model parameters at
any given moment, for linear iv models.
}
\examples{
dat <- calc_auc_analytic(
  f = "2cmt_iv_infusion",
  regimen = new_regimen(
    amt = 1000, n = 10, type = "infusion",
    t_inf = 1, interval = 24
  ),
  parameters = list(CL = 5, V = 50, Q = 8, V2 = 150)
)

}
