% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_surv_model_pred_gr}
\alias{f_surv_model_pred_gr}
\title{Group Predictions by Survival Model}
\usage{
f_surv_model_pred_gr(
  ngroups,
  surv_model,
  surv_model_pred,
  spline_mod,
  cure_mod
)
}
\arguments{
\item{ngroups}{Integer. Number of groups.}

\item{surv_model}{List of survival models from \code{\link[=f_surv_model]{f_surv_model()}}.}

\item{surv_model_pred}{List of predictions from \code{\link[=f_surv_model_pred]{f_surv_model_pred()}}.}

\item{spline_mod}{Logical. Whether spline models were fitted.}

\item{cure_mod}{Logical. Whether cure models were fitted.}
}
\value{
A list of length \code{ngroups}, each a data frame with columns:
\itemize{
\item \code{time}
\item survival predictions for all models (parametric, spline, cure).
}
}
\description{
Consolidates predictions from \code{\link[=f_surv_model_pred]{f_surv_model_pred()}} into
group-specific data frames.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
form <- stats::as.formula(survival::Surv(years, status) ~ group)
surv_model <- f_surv_model(
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  ngroups = nlevels(group),
  form = form,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  group_names = levels(group)
)
surv_model_pred <- f_surv_model_pred(
  ngroups = nlevels(group),
  time_pred = seq(0, 5000, 365.25),
  surv_model = surv_model,
  spline_mod = FALSE,
  cure_mod = FALSE,
  group_names = levels(group)
)
f_surv_model_pred_gr(
  ngroups = nlevels(group),
  surv_model = surv_model,
  surv_model_pred = surv_model_pred,
  spline_mod = FALSE,
  cure_mod = FALSE
)

}
