% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-simulation.R
\name{PCBN_sim}
\alias{PCBN_sim}
\title{Simulate data from a specified PCBN}
\usage{
PCBN_sim(object, N, check_PCBN = TRUE, verbose = 1)
}
\arguments{
\item{object}{PCBN object to simulate from.
\bold{This does not work if the PCBN does not abide by the B-sets.
And in general, it does not work if the PCBN is outside of
the class of restricted PCBNs.}}

\item{N}{sample size}

\item{check_PCBN}{check whether the given PCBN satisfies the restrictions.
If this is set to \code{FALSE}, no checking is performed.
This means that the error due to the a non-restricted PCBN object (if this
is the case) will occur later in the computations (and may not be so clear -
typically it is because of failing to find a given conditional copula).
Nevertheless, even with `check_PCBN = TRUE` if could be that some error happen
later if the parental orderings are not compatible with each other.}

\item{verbose}{if \code{0}, don't print anything.
If \code{verbose >= 1}, print information about the simulation procedure.}
}
\value{
a data frame of N samples
}
\description{
Simulate data from a specified PCBN
}
\examples{
DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)

tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

mydata = PCBN_sim(my_PCBN, N = 5)


}
