% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuPa_honest_forest.R
\name{NuPa_honest_forest}
\alias{NuPa_honest_forest}
\title{Nuisance parameter estimation via honest random forest}
\usage{
NuPa_honest_forest(
  NuPa = c("Y.hat", "Y.hat.d", "Y.hat.z", "D.hat", "D.hat.z", "Z.hat"),
  X,
  Y = NULL,
  D = NULL,
  Z = NULL,
  n_cf_folds = 5,
  n_reps = 1,
  cluster = NULL,
  progress = FALSE,
  ...
)
}
\arguments{
\item{NuPa}{String vector specifying the nuisance parameters to be estimated.
Currently supported: \code{c("Y.hat","Y.hat.d","Y.hat.z","D.hat","D.hat.z","Z.hat")}}

\item{X}{Covariate matrix with N rows and p columns.}

\item{Y}{Optional numeric vector containing the outcome variable.}

\item{D}{Optional binary treatment variable.}

\item{Z}{Optional binary instrumental variable.}

\item{n_cf_folds}{Number of cross-fitting folds. Default is 5.}

\item{n_reps}{Number of repetitions of cross-fitting. Default is 1.}

\item{cluster}{Optional vector of cluster variable if cross-fitting should account for clusters.}

\item{progress}{If TRUE, progress of nuisance parameter estimation reported.}

\item{...}{Options passed to the \code{\link[grf]{regression_forest}}.}
}
\value{
List of two lists.
\itemize{
\item \code{predictions} contains the requested nuisance parameters
\item \code{smoothers} contains the smoother matrices of requested outcome nuisance parameters
\item \code{cf_mat} Array of dimension n_reps x N x n_cf_folds storing indicators representing the folds used in estimation.
}
}
\description{
This function estimates different nuisance parameters using the honest random forest
implementation of the 'grf' package
}
\references{
Wager, S., & Athey, S. (2018). Estimation and inference of heterogeneous treatment effects using random forests.
Journal of the American Statistical Association, 113(523), 1228-1242.
}
