% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otsu_threshold_smoothed.R
\name{otsu_threshold_smoothed}
\alias{otsu_threshold_smoothed}
\title{Otsu's Thresholding with Smoothed Histogram}
\usage{
otsu_threshold_smoothed(hist_vals, mids)
}
\arguments{
\item{hist_vals}{A numeric vector of histogram counts.}

\item{mids}{A numeric vector of histogram bin midpoints.}
}
\value{
The optimal threshold value.
}
\description{
This is an internal function that applies Otsu's thresholding to a smoothed histogram to determine the optimal threshold
for image segmentation. It is not intended for direct use by package users.
}
\examples{
\donttest{
  hist_vals <- hist(rnorm(1000), plot = FALSE)$counts
  mids <- hist(rnorm(1000), plot = FALSE)$mids
  threshold <- otsu_threshold_smoothed(hist_vals, mids)
  print(threshold)
}
}
\keyword{internal}
