% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_external_data.R
\name{get_external_data}
\alias{get_external_data}
\title{Download and load example data for OtsuSeg}
\usage{
get_external_data(filename = NULL, path = tempdir(), load = FALSE)
}
\arguments{
\item{filename}{Optional. The name of the file to return (after extraction).}

\item{path}{Local directory to download and extract files. Default is a temp folder.}

\item{load}{Logical. If TRUE, returns a loaded object (RasterLayer for .tif, sf for .shp). Default is FALSE.}
}
\value{
File path or loaded object if `load = TRUE`.
}
\description{
Downloads a ZIP file with example rasters and shapefiles from GitHub releases and optionally loads a specific file.
}
\examples{
\donttest{
# Download example data and list contents
data_dir <- get_external_data(path = tempdir())
list.files(data_dir)

# Load a specific raster file (.tif)
pre_fire <- get_external_data("NBRpre.tif", path = tempdir(), load = TRUE)
print(pre_fire)

# Load a specific shapefile (.shp)
shape_data <- get_external_data("shapefile_reference.shp", path = tempdir(), load = TRUE)
print(shape_data)
}

}
