% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgl-3d.r
\name{biplot3d}
\alias{biplot3d}
\title{Draw grid in rgl (3D device).}
\usage{
biplot3d(
  x,
  dim = 1:3,
  labels.e = TRUE,
  labels.c = TRUE,
  lines.c = 2,
  lef = 1.3,
  center = 1,
  normalize = 0,
  g = 0,
  h = 1,
  col.active = NA,
  col.passive = NA,
  c.axis.show = TRUE,
  c.sphere.show = FALSE,
  c.sphere.col = grey(0.4),
  c.cex = 0.6,
  c.text.col = grey(0.4),
  e.sphere.show = TRUE,
  e.labels.show = TRUE,
  e.sphere.col = grey(0),
  e.cex = 0.6,
  e.text.col = grey(0),
  alpha.sphere = 0.05,
  col.sphere = "black",
  unity = FALSE,
  unity3d = FALSE,
  scale.e = 0.9,
  zoom = 1,
  ...
)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{dim}{Dimensions to display.}

\item{labels.e}{Logical. whether element labels are displayed.}

\item{labels.c}{Logical. whether construct labels are displayed.}

\item{lines.c}{Numeric. The way lines are drawn through the construct vectors.
\verb{0 =} no lines, \verb{1 =} lines from constructs to outer frame,
\verb{2 =} lines from the center to outer frame.}

\item{lef}{Construct lines extension factor}

\item{center}{Numeric. The type of centering to be performed.
0= no centering, 1= row mean centering (construct),
2= column mean centering (elements), 3= double-centering (construct and element means),
4= midpoint centering of rows (constructs).
Default is \code{1} (row centering).}

\item{normalize}{A numeric value indicating along what direction (rows, columns)
to normalize by standard deviations. \verb{0 = none, 1= rows, 2 = columns}
(default is \code{0}).}

\item{g}{Power of the singular value matrix assigned to the left singular
vectors, i.e. the constructs.}

\item{h}{Power of the singular value matrix assigned to the right singular
vectors, i.e. the elements.}

\item{col.active}{Columns (elements) that are no supplementary points, i.e. they are used
in the SVD to find principal components. default is to use all elements.}

\item{col.passive}{Columns (elements) that are supplementary points, i.e. they are NOT used
in the SVD but projected into the component space afterwards. They do not
determine the solution. Default is \code{NA}, i.e. no elements are set
supplementary.}

\item{c.axis.show}{Whether the construct axes are shown (default is \code{TRUE}).
\code{FALSE} will suppress the printing all axes.
To only print certain axes, a numeric vector can be provided (e.g. \code{c(1:10)}).}

\item{c.sphere.show}{Whether the construct speheres are shown (default is \code{FALSE}).
To only print certain speheres, a numeric vector can be provided (e.g. \code{c(1:10)}).}

\item{c.sphere.col}{Color of construct spheres.}

\item{c.cex}{Size of construct text.}

\item{c.text.col}{Color for construct text.}

\item{e.sphere.show}{Whether the elements are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the elements.
To only print certain elements, a numeric vector can be provided (e.g. \code{c(1:10)}).}

\item{e.labels.show}{Whether the element labels are printed (default is \code{TRUE}).
\code{FALSE} will suppress the printing of the labels.
To only print certain element labels, a numeric vector can be provided (e.g. \code{c(1:10)}).}

\item{e.sphere.col}{Color of elements.}

\item{e.cex}{Size of element labels.}

\item{e.text.col}{Color of element labels.}

\item{alpha.sphere}{Numeric. alpha blending of the surrounding sphere (default\code{".05"}).}

\item{col.sphere}{Color of surrounding sphere (default\code{"black"}).}

\item{unity}{Scale elements and constructs coordinates to unit scale (maximum of 1)
so they are printed more neatly (default \code{TRUE}).}

\item{unity3d}{To come.}

\item{scale.e}{Scaling factor for element vectors. Will cause element points to move a bit more
to the center (but only if \code{unity} or \code{unity3d} is \code{TRUE}).
This argument is for visual appeal only.}

\item{zoom}{Not yet used. Scaling factor for all vectors. Can be used to zoom
the plot in and out (default \code{1}).}

\item{...}{Parameters to be passed on.}
}
\description{
The 3D biplot opens an interactive
3D device that can be rotated and zoomed using the mouse.
A 3D device facilitates the exploration of grid data as
significant proportions of the sum-of-squares are often
represented beyond the first two dimensions. Also, in a lot of
cases it may be of interest to explore the grid space from
a certain angle, e.g. to gain an optimal view onto the set
of elements under investigation (e.g. Raeithel, 1998).
}
\examples{
\dontrun{
biplot3d(boeker)

biplot3d(boeker, e.sphere.show = 1:4)
biplot3d(boeker, e.sphere.show = 1:4, e.labels.show = 1:2)
biplot3d(boeker, c.axis.show = 1:2)

biplot3d(boeker, e.sphere.col = "red", c.text.col = "blue")
biplot3d(boeker, e.cex = 1)
biplot3d(boeker, col.sphere = "red")

biplot3d(boeker, g = 1, h = 1) # INGRID biplot
biplot3d(boeker, g = 1, h = 1, center = 4) # ESA biplot
}
}
\references{
Raeithel, A. (1998). Kooperative Modellproduktion von
Professionellen und Klienten - erlauetert am Beispiel des
Repertory Grid. \emph{Selbstorganisation, Kooperation, Zeichenprozess:
Arbeiten zu einer kulturwissenschaftlichen, anwendungsbezogenen
Psychologie} (pp. 209-254). Opladen: Westdeutscher Verlag.
}
\seealso{
Unsophisticated biplot: \code{\link[=biplotSimple]{biplotSimple()}}; \cr
2D biplots:
\code{\link[=biplot2d]{biplot2d()}},
\code{\link[=biplotEsa2d]{biplotEsa2d()}},
\code{\link[=biplotSlater2d]{biplotSlater2d()}};\cr
Pseudo 3D biplots:
\code{\link[=biplotPseudo3d]{biplotPseudo3d()}},
\code{\link[=biplotEsaPseudo3d]{biplotEsaPseudo3d()}},
\code{\link[=biplotSlaterPseudo3d]{biplotSlaterPseudo3d()}};\cr
Interactive 3D biplots:
\code{\link[=biplot3d]{biplot3d()}},
\code{\link[=biplotEsa3d]{biplotEsa3d()}},
\code{\link[=biplotSlater3d]{biplotSlater3d()}};\cr
Function to set view in 3D:
\code{\link[=home]{home()}}.
}
