#' OPL: Optimal Policy Learning Package
#'
#' The OPL package provides tools for estimating and optimizing policy assignment rules
#' based on machine learning and econometric techniques.
#'
#' @section Main functions:
#' - `make_cate()`: Computes conditional average treatment effects.
#' - `opl_tb()`: Optimal policy learning for threshold-based policies.
#' - `opl_lc()`: Optimal policy learning for linear combination policies.
#' - `opl_dt()`: Optimal policy learning for decision tree-based policies.
#'
#' @section Installation:
#' To install the package from CRAN, use:
#' \code{install.packages("OPL")}
#'
#' @section Acknowledgments:
#' The development of this software was supported by FOSSR (Fostering Open Science in Social Science Research), a project funded by the European Union - NextGenerationEU under the NPRR Grant agreement n. MURIR0000008.
#'
#' @keywords internal
#' "_PACKAGE"
#' @name OPL
NULL

