% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_condition_sib_model.R
\name{initial_condition_sib_model}
\alias{initial_condition_sib_model}
\title{Provide Initial Condition for Function SIB_SS}
\usage{
initial_condition_sib_model(
  POP_node,
  sigma,
  mu_B,
  theta,
  node_in,
  in_prevalence = 0.001
)
}
\arguments{
\item{POP_node}{vector, length represents number of cities/nodes; vector represents
population at each node}

\item{sigma}{symptomatic ratio, i.e., fraction of infected people that develop symptoms and are infective. 
(The remaining fraction enters directly the recovered compartment.)}

\item{mu_B}{death rate of V.cholerae in the aquatic environment (day^-1)}

\item{theta}{contamination rate}

\item{node_in}{index/indices for initial infected node(s)}

\item{in_prevalence}{initial prevalence of symptomatic infected in a node, default is 0.1\%}
}
\value{
a 5 x number of nodes matrix, each row represents the following for all the nodes:
        Row 1: number of suspectible people, i.e., population excpect infected and recovered for each node;
        Row 2: number of infected people;
        Row 3: number of recovered people;
        Row 4: bacteria concentration in equilibrium with infected individuals;
        Row 2: number of infected people, but representing cumulative cases
}
\description{
\code{initial_condition_sib_model} Compute Initial Condition for Function SIB_SS
}
\examples{
set.seed(2020)
popu <- rep(20000, 10)
sigma <- 0.05
mu_B <- 0.2
theta_max <- 16
theta <- runif(10, 0.1, 0.9) * theta_max
y0 <- initial_condition_sib_model(popu, sigma, mu_B, theta, c(3))
}
\author{
Jun Li
}
