% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-links.R
\name{nc_estimate_links}
\alias{nc_estimate_links}
\alias{nc_estimate_exposure_links}
\alias{nc_estimate_outcome_links}
\title{Compute model estimates between an external (exposure or outcome) variable
and a network.}
\usage{
nc_estimate_exposure_links(
  data,
  edge_tbl,
  exposure,
  adjustment_vars = NA,
  model_function,
  model_arg_list = NULL,
  exponentiate = FALSE,
  classify_option_list = classify_options()
)

nc_estimate_outcome_links(
  data,
  edge_tbl,
  outcome,
  adjustment_vars = NA,
  model_function,
  model_arg_list = NULL,
  exponentiate = FALSE,
  classify_option_list = classify_options()
)
}
\arguments{
\item{data}{The data.frame or tibble that contains the variables of interest,
including the variables used to make the network.}

\item{edge_tbl}{Output graph object from \code{nc_estimate_network()}, converted
to an edge table using \code{as_edge_tbl()}.}

\item{exposure, outcome}{Character. The exposure or outcome variable of interest.}

\item{adjustment_vars}{Optional. Variables to adjust for in the models.}

\item{model_function}{A function for the model to use (e.g. \code{\link[stats:lm]{stats::lm()}},
\code{\link[stats:glm]{stats::glm()}}, survival::coxph()). Can be any model as long as the
function has the arguments \code{formula} and \code{data}. Type in the model function
as a bare object (without \verb{()}, for instance as \code{lm}).}

\item{model_arg_list}{Optional. A list containing the named arguments that
will be passed to the model function. A simple example would be
\code{list(family = binomial(link = "logit"))} to specify that the \code{glm} model
is a logistic model and not a linear one. See the examples for more on the
usage.}

\item{exponentiate}{Logical. Whether to exponentiate the log estimates, as
computed with e.g. logistic regression models.}

\item{classify_option_list}{A list with classification options for direct, ambigious, or no
effects. Used with the \code{classify_options()} function with the arguments:
\itemize{
\item \code{single_metabolite_threshold}: Default of 0.05. P-values from models with
only the index metabolite (no neighbour adjustment) are classified as effects if
below this threshold. For larger sample sizes and networks, we recommend lowering
the threshold to reduce risk of false positives.
\item \code{network_threshold}: Default of 0.1. P-values from any models that have
direct neighbour adjustments are classified as effects if below this threshold.
This is assumed as a one-sided p-value threshold. Like the threshold above,
a lower value should be used for larger sample sizes and networks.
\item \code{direct_effect_adjustment}: Default is NA. After running the algorithm once,
sometimes it's useful to adjust for the direct effects identified to confirm
whether other links exist.
}}
}
\value{
Outputs a \link[tibble:tibble-package]{tibble} that contains the model
estimates from either the exposure or outcome side of the network as well
as the effect classification. Each row represents the "no neighbour node
adjusted" model and has the results for the outcome/exposure to index node
pathway.
Columns for the outcome are:
\itemize{
\item \code{outcome} or \code{exposure}: The name of the variable used as the external variable.
\item \code{index_node}: The name of the metabolite used as the index node from the network.
In combination with the outcome/exposure variable, they represent the individual
model used for the classification.
\item \code{estimate}: The estimate from the outcome/exposure and index node model.
\item \code{std_error}: The standard error from the outcome/exposure and index node model.
\item \code{fdr_p_value}: The False Discovery Rate-adjusted p-value from the
outcome/exposure and index node model.
\item \code{effect}: The NetCoupler classified effect between the index node and the
outcome/exposure. Effects are classified as "direct" (there is a probable link
based on the given thresholds), "ambigious" (there is a potential link but
not all thresholds were passed), and "none" (no potential link seen).
}

The tibble output also has an attribute that contains all the models
generated \emph{before} classification. Access it with \code{attr(output, "all_models_df")}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is the main function that identifies potential links between external factors
and the network. There are two functions to estimate and classify links:
\itemize{
\item \code{nc_estimate_exposure_links()}: Computes the model estimates for the exposure side.
\item \code{nc_estimate_outcome_links()}: Computes the model estimates for the exposure side.
}
}
\examples{

standardized_data <- simulated_data \%>\%
    nc_standardize(starts_with("metabolite"))

metabolite_network <- simulated_data \%>\%
    nc_standardize(starts_with("metabolite"),
                   regressed_on = "age") \%>\%
    nc_estimate_network(starts_with("metabolite"))
edge_table <- as_edge_tbl(metabolite_network)

results <- standardized_data \%>\%
  nc_estimate_exposure_links(
    edge_tbl = edge_table,
    exposure = "exposure",
    model_function = lm
   )
results

# Get results of all models used prior to classification


}
\seealso{
\code{vignette("examples")} article has more
details on how to use NetCoupler with different models.
}
