% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngchmshaidy.R
\name{chmCreateCollection}
\alias{chmCreateCollection}
\title{Create a new NG-CHM Collection}
\usage{
chmCreateCollection(path, recursive = FALSE)
}
\arguments{
\item{path}{The path where the collection should be created. This should be a single character string.}

\item{recursive}{A logical value indicating whether to create parent collections if they do not exist. Default is FALSE.}
}
\value{
None. This function is used for its side effects of creating a new collection on the server.
}
\description{
This function creates a new NG-CHM (Next-Generation Clustered Heat Map) collection on the server.
}
\details{
The path is a sequence of components separated by slashes (/).
If the path begins with a double slash (//) the following
component is interpreted as a server name. If the server name is
omitted (i.e. empty) the default server will be used.  If the path
does not begin with a double slash, the current server will be used.

If the path begins with a slash, the components (following the
server, if specified) are interpreted relative to
the root collection of the server concerned.  Otherwise, they
are interpreted relative to the current collection.

The interpretation of each path component is server specific.
}
\seealso{
\code{\link[=chmCurrentCollection]{chmCurrentCollection()}}
}
