% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_func.R
\name{summaryTrend}
\alias{summaryTrend}
\title{Trend Tests Summary}
\usage{
summaryTrend(data, width, covar = NULL)
}
\arguments{
\item{data}{Numeric matrix, a two dimensional data set where each column is a
variable.}

\item{width}{Numeric value, the width to be used for the \emph{moving window} algorithm.
Should be bigger than 1 and smaller than the number of observations.}

\item{covar}{Numeric vector, time order of the data series. If none give \eqn{covar = 1, 2, ..., n}.}
}
\value{
The results dataframe, a column for the respective test statistic, a column
for the p-value, and four rows each for a test MDT, MOT, and MK for each variable.
}
\description{
Performs multivariate and univariate trend tests on the given data series
and returns a data frame with the results.
}
\details{
The function performs the Multivariate Dependence Trend and Multivariate Overall
Trend tests as described by Goutali and Chebana (2024), as well as the univariate
Mann-Kendall (MK) test to each variable and returns a data frame with the results.

This functions performs the test with the default values for \code{alpha = 0.05} and \code{Nbs = 1000},
for a more precise testing you can use the functions described in \strong{see also}.
}
\examples{

\donttest{
# Summary for data with trend in the Dependence Structure:
DependenceStructure <- generate_data("dependenceStructure", 50)
summaryTrend(DependenceStructure, covar = NULL, width = 10)

# Summary for data with trend in the Marginals:
MarginalTrend <- generate_data("marginalTrend", 50)
summaryTrend(MarginalTrend, covar = NULL, width = 10)

# Summary for data without trend:
NoTrend <- generate_data("noTrend", 50)
summaryTrend(NoTrend, covar = NULL, width = 10)
}

}
\references{
Goutali, D., and Chebana, F. (2024). Multivariate overall and dependence trend tests, applied to hydrology,
Environmental Modelling & Software, 179, \doi{10.1016/j.envsoft.2024.106090}
}
\seealso{
\itemize{
\item \link{MDT_test}: Function used to perform the MDT test.
\item \link{MOT_test}: Function used to compute the MOT test.
\item \link{mkUnivariate}: Function used to perform the univariate MK test.
}
}
