% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordenadasPrincipais.R
\name{CoordenadasPrincipais}
\alias{CoordenadasPrincipais}
\title{Estudo de coordenadas principais}
\usage{
CoordenadasPrincipais(Dist, layout = 1,
main = NULL, NomeTrat = NULL, xlab = "PCoA 1", ylab ="PCoA 2",
ColVars = c(1, 2), CR = TRUE, Perc = 0.01, plot = TRUE)
}
\arguments{
\item{Dist}{Matriz com as medidas de dissimilaridade.}

\item{layout}{Deve ser um numero variando de 1 a 8. Para cada numero teremos
um layout diferente.}

\item{main}{Titulo do grafico.}

\item{NomeTrat}{Nome dos tratamentos.}

\item{xlab}{Nome do eixo x no grafico.}

\item{ylab}{Nome do eixo y no grafico.}

\item{ColVars}{Numero dos eixos que se pretende apresentar no grafico.
O padrao e `c(1,2)`.}

\item{CR}{Valor logico (TRUE ou FALSE) indicando se aparecera no grafico
a contriuicao relativa de cada eixo.}

\item{Perc}{Valor entre 0 e 1 indicando o recuo dos eixos.}

\item{plot}{Valor logico.Se for TRUE o grafico sera apresentado.}
}
\value{
Esta funcao retorna informacoes importantes para o estudo de
  coordenadas principais.
}
\description{
Esta funcao possibilita o estudo dos coordenadas principais.
}
\examples{
#Exemplo com dados Quantitativos
data("Dados.MED")
Dist=Distancia(Dados.MED,Metodo=5)
CoordenadasPrincipais(Dist)
#Compare os resultados com os componentes principais
ComponentesPrincipais(Dados.MED,padronizar = TRUE)

#Exemplo com dados Qualitativos

data=data("Dados.CAT")
Dist=Distancia(Dados.CAT,Metodo=10)
CoordenadasPrincipais(Dist)
}
\references{
PlayList "Curso de Analise Multivariada":
 https://www.youtube.com/playlist?list=PLvth1ZcREyK72M3lFl7kBaHiVh5W53mlR

Cailliez, F. (1983) The analytical solution of the additive constant problem.
Psychometrika, 48, 305–308.

CRUZ, C.D. and CARNEIRO, P.C.S.  Modelos biometricos aplicados ao
  melhoramento genetico. 3nd Edition. Vicosa, UFV, v.2, 2014. 668p.
  (ISBN: 8572691510)

FERREIRA, D.F. Estatistica Multivariada. (2018) 3ed. UFLA. 624p.
(ISBN 13:978 8581270630)

Paradis, E.; Schliep, K. ape 5.0: an environment for modern phylogenetics
and evolutionary analyses in R. (2019) Bioinformatics. 526-528.

 HAIR, J.F. Multivariate Data Analysis.  (2016) 6ed. Pearson Prentice HalL.
  (ISBN 13:978 0138132637)

 Lingoes, J. C. (1971) Some boundary conditions for a monotone analysis of
  symmetric matrices. Psychometrika, 36, 195–203.
}
\seealso{
\code{\link{ComponentesPrincipais}}
}
