% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{generate_patterns}
\alias{generate_patterns}
\title{Missing-Data Pattern Generation}
\usage{
generate_patterns(d)
}
\arguments{
\item{d}{The number of variables or columns of the data set. \code{d} must be
an integer greater than 1.}
}
\value{
A matrix where 0 indicates that a variable should have missing values
  and 1 indicates that a variable should remain complete. This matrix has \code{d}
  columns and \eqn{2^d - 2} rows.
}
\description{
Generate all possible missing patterns in a multivariate data set. The function
can be used to complement the function \code{ampute()} from package \code{mice}
in which a matrix of patterns is needed to allow for general missing-data
patterns with missing-data mechanism missing at random (MAR). Using this
function, each observation can have more than one missing value.
}
\details{
An observation cannot have all values missing values. A complete observation
  is not qualified for missing-data pattern. Note that a large value of \code{d} may
  result in memory allocation error.
}
\examples{
generate_patterns(4)

#++++ To use with the function ampute() from package mice ++++#
library(mice)

patterns_matr <- generate_patterns(4)
data_missing <- ampute(iris[1:4], prop = 0.5, patterns = patterns_matr)$amp

}
