% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{plot.MicrobialGrowth}
\alias{plot.MicrobialGrowth}
\title{MicrobialGrowth plot function}
\usage{
\method{plot}{MicrobialGrowth}(
  x,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  n = 101,
  base = exp(1),
  display.coefficients = TRUE,
  display.model = TRUE,
  display.confint = FALSE,
  reg.args = list(col = "red"),
  title.args = list(line = 2),
  model.args = list(side = 4, line = 0),
  coefficients.args = list(cex = 0.9, line = 0.2, side = 3),
  confint.args = list(),
  ...
)
}
\arguments{
\item{x}{MicrobialGrowth-object.}

\item{main}{main title for the plot.}

\item{xlab}{title for the x axis.}

\item{ylab}{title for the y axis.}

\item{n}{the number of x values at which to evaluate. See details section.}

\item{base}{the logarithm base used for plot y-scaling. By default, the natural logarithm is used. Set \code{NULL} to not scale.}

\item{display.coefficients}{boolean indicating the display or not of the values of coefficients (under the main title).}

\item{display.model}{boolean indicating the model used for regression (on right side).}

\item{display.confint}{boolean indicating the display or not of confidence intervals (in the form of curves and area).}

\item{reg.args}{customization parameters of the curve obtained by regression (see \link[graphics]{curve} for possible parameters).}

\item{title.args}{title customization parameters \code{main}, \code{xlab} and \code{ylab} (see \link[graphics]{title} for possible parameters).}

\item{model.args}{model display customization parameters (see \link[graphics]{mtext} for possible parameters).}

\item{coefficients.args}{coefficient display customization parameters (see \link[graphics]{mtext} for possible parameters).}

\item{confint.args}{parameters for customizing the plotting of curves and area, corresponding to the confidence interval (see details section).}

\item{...}{other graphical parameters (see \link[base]{plot}).}
}
\value{
No return value, called to plot a MicrobialGrowth-object.
}
\description{
Plot function of MicrobialGrowth-objects.
}
\details{
Similar to the \code{curve} function, the \code{n} argument corresponds to the number of points evaluated to draw the curves of regression, confidence bounds and the associated area. Increase its value for a more accurate representation.

When \code{base} is not \code{NULL}, the plot produced is \eqn{log_n(N/N0)}, where n is the value specified in the \code{base} argument.
}
\examples{
# Example plot of a MicrobialGrowth-object obtained by regression
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz")
plot(g)

# Example plot of a user-created MicrobialGrowth-object (via MicrobialGrowth.create)
g <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
                                  xlim = c(0, 100), model="gompertz")
plot(g)

# Example plot with usual graphical parameters
plot(g, pch = 4, cex = 2, col = "blue", xlab = "Time (hours)", main = "Gompertz regression")

# Example of plot hiding the coefficients and customizing the curve obtained by regression
plot(g, display.coefficients = FALSE, reg.args = list(col = "green", lty = 2, lwd = 5))

# Example of a plot displaying the curves and area of the confidence interval
g <- MicrobialGrowth(example_data$time, example_data$y1, model="gompertz")
plot(g, display.confint = TRUE)

# Example of a plot customizing the confidence interval
plot(g, xlim = c(80, 100), ylim = c(1.8, 2.4), # Zoom in to see the example better
display.confint = TRUE,
confint.args = list(
  lines = list(col = "purple", lty = 2, lwd = 2),
  area = list(col = "green", opacity = 0.1)
))

# Example of a plot customizing the display of coefficients and titles
plot(g, main = "Gompertz",
coefficients.args = list(cex = 1.5, side = 4, line = 1),
title.args = list(col.main = "blue", col.lab = "red"))
}
