% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz.R
\name{gompertz.create}
\alias{gompertz.create}
\title{Gompertz create function}
\usage{
gompertz.create(N0, Nmax, mu, lambda, xlim, n = 101)
}
\arguments{
\item{N0}{initial population.}

\item{Nmax}{final/maximum population.}

\item{mu}{growth rate.}

\item{lambda}{latency time.}

\item{xlim}{range of values to simulate \code{x} and \code{y} (and hence plotting, \emph{etc.})}

\item{n}{number of points to simulate in the interval \code{xlim}.}
}
\value{
a Gompertz-object composed of
\item{call}{the matched call with several components.}
\item{coefficients}{coefficients obtained by regression.}
\item{data}{data used for regression, once the y values are clipped}
\item{f}{a list of functions such as \code{formula} to retrieve the function of the model with the coefficients obtained by regression, \code{confint} to retrieve the confidence intervals, etc.}
\item{isValid}{a boolean indicating whether the regression was successful or not.}
\item{message}{always with this method.}
\item{reg}{always with this method.}
}
\description{
Gompertz-object creator from the 4 biological meaning parameters.
}
\seealso{
\link{MicrobialGrowth.create}
}
