% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baranyi.R
\name{.baranyi.formula}
\alias{.baranyi.formula}
\title{Baranyi equation.}
\usage{
.baranyi.formula(N0, Nmax, mu, lambda, base = exp(1))
}
\arguments{
\item{N0}{initial population.}

\item{Nmax}{final/maximum population.}

\item{mu}{growth rate.}

\item{lambda}{latency time.}

\item{base}{the logarithm base used for plot y-scaling. By default, the natural logarithm is used. Set \code{NULL} to not scale.}
}
\value{
a function taking as input x (the time) and outputting the value of the Baranyi equation.
}
\description{
Baranyi equation.
}
\details{
The output result is by default in the form \code{ln(N_t/N0)} (with \code{N_t} the population at time \code{t}).
The base used can be modified by specifying the desired base in the \code{base} argument.
For example, specifying \code{base=10} corresponds to output in the form \verb{log_\{10\}(N_t/N0)}.
It is possible to specify \code{base = NULL} to retrieve the normal \code{N_t} output.
}
\examples{
f <- .baranyi.formula(0.1, 2, 0.2, 5)
f(4)
## [1] 0.3498583
f(20)
## [1] 2.344923
}
