% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-1.layout.R
\name{g_layout}
\alias{g_layout}
\title{Layout with group}
\usage{
g_layout(
  go,
  group = "module",
  group_order = NULL,
  layout1 = in_circle(),
  zoom1 = 20,
  layout2 = in_circle(),
  zoom2 = 3,
  show_big_layout = FALSE,
  rescale = TRUE,
  ...
)
}
\arguments{
\item{go}{igraph or metanet object}

\item{group}{group name (default: module)}

\item{group_order}{group_order}

\item{layout1}{layout1 method, one of
(1) a dataframe or matrix: rowname is group, two columns are X and Y
(2) function: layout method for \code{\link{c_net_layout}} default: in_circle()}

\item{zoom1}{big network layout size}

\item{layout2}{one of functions: layout method for \code{\link{c_net_layout}}, or a list of functions.}

\item{zoom2}{average sub_network layout size, or numeric vector, or "auto"}

\item{show_big_layout}{show the big layout to help you adjust.}

\item{rescale}{logical, scale the X, Y to (-1,1)}

\item{...}{add}
}
\value{
coors
}
\description{
Layout with group
}
\examples{
\donttest{
data("c_net")
module_detect(co_net, method = "cluster_fast_greedy") -> co_net_modu
g_layout(co_net_modu, group = "module", zoom1 = 30, zoom2 = "auto", layout2 = as_line()) -> oridata
plot(co_net_modu, coors = oridata)
}
}
\seealso{
Other g_layout: 
\code{\link{g_layout_nice}()},
\code{\link{g_layout_poly_sector}()},
\code{\link{g_layout_polygon}()}
}
\concept{g_layout}
