% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois.est.R
\name{pois_est}
\alias{pois_est}
\title{Method of Moments Estimation of Poisson distribution}
\usage{
pois_est(data, plot = TRUE, curvecol = "red", ...)
}
\arguments{
\item{data}{A numeric vector.}

\item{plot}{logical which controls whether the barplot of the data along with the probability curve of the theoretical poisson distribution with the estimated parameters.}

\item{curvecol}{color of the theoretical probability curve}

\item{...}{additional plotting parameters}
}
\value{
the estimated parameters by the method of moments of the data assuming the underlying distribution is poisson distribution
}
\description{
function to get the method of moment estimate(s) of poisson distribution
}
\examples{
pois_est(data=rpois(1000,lambda=2),plot=TRUE)
pois_est(data=rpois(1000,lambda=0.2),plot=FALSE)#will not give the plot
}
