#'Method of Moments Estimation of Negative Binomial distribution
#'@description function to get the method of moment estimate(s) of negative binomial distribution
#'@param data A numeric vector.
#'@param plot logical which controls whether the barplot of the data along with the probability curve of the theoretical negative binomial distribution with the estimated parameters.
#'@param curvecol color of the theoretical probability curve
#'@param ... additional plotting parameters
#'@importFrom stats dnbinom
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is geometric distribution
#'@examples
#'geom_est(rgeom(1000,prob=0.2))
#'@export
geom_est=function(data,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  size=1
  p=1/avg
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dgeom(x,prob=p),from=0,to=floor(max(data)),n=floor(max(data))+1,add=T,col=curvecol)
  }
  output=list(p)
  names(output)=c("prob")
  return(output)
}
