#'Method of Moments Estimation of Chi-Square distribution
#'@description function to get the method of moment estimate(s) of chi-square distribution
#'@param data A numeric vector.
#'@param plot logical which controls whether the histogram of the data along with the density curve of the theoretical chi square distribution with the estimated parameters.
#'@param curvecol color of the theoretical density curve
#'@param ... additional plotting parameters
#'@importFrom stats dchisq
#'@importFrom graphics hist
#'@return the estimated degree of freedom by the method of moments of the data assuming the underlying distribution is chi square distribution
#'@examples
#'chisq_est(rchisq(1000,df=3))
#'@export
chisq_est=function(data,plot=TRUE,curvecol="red",...)
{
  df=mean(data)
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dchisq(x,df=df),add=TRUE,col=curvecol)
  }
  output=list(df)
  names(output)=c("df")
  return(output)
}
