% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.MLGL}
\alias{plot.MLGL}
\title{Plot the path obtained from \code{\link{MLGL}} function}
\usage{
\method{plot}{MLGL}(x, log.lambda = FALSE, lambda.lines = FALSE, ...)
}
\arguments{
\item{x}{\code{\link{MLGL}} object}

\item{log.lambda}{If TRUE, use log(lambda) instead of lambda in abscissa}

\item{lambda.lines}{if TRUE, add vertical lines at lambda values}

\item{...}{Other parameters for plot function}
}
\description{
Plot the path obtained from \code{\link{MLGL}} function
}
\examples{
# Simulate gaussian data with block-diagonal variance matrix containing 12 blocks of size 5
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
# Generate a response variable
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
# Apply MLGL method
res <- MLGL(X, y)
# Plot the solution path
plot(res)

}
\seealso{
\link{MLGL}
}
