% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ECHACR.R
\name{cubeECHACR}
\alias{cubeECHACR}
\title{Inheritance Cube: ECHACR}
\usage{
cubeECHACR(
  cHW = 1,
  cEW = 1,
  cEH = 1,
  chHW = 0,
  crHW = 0,
  ceEW = 0,
  crEW = 0,
  ceEH = 0,
  crEH = 0,
  d1 = 0,
  d2 = 0,
  d3 = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cHW}{Cutting efficiency of drive allele at locus 1}

\item{cEW}{Cutting efficiency of ECHACR element into W}

\item{cEH}{Cutting efficiency of ECHACR element into H}

\item{chHW}{Homing efficiency of drive allele at locus 1}

\item{crHW}{Resistance allele efficiency of drive allele at locus 1}

\item{ceEW}{Homing efficiency of ECHACR element into W}

\item{crEW}{Resistance allele efficiency of ECHACR element into W}

\item{ceEH}{Homing efficiency of ECHACR element into H}

\item{crEH}{Resistance allele efficiency of ECHACR element into H}

\item{d1}{Background mutation rate from W into R allele}

\item{d2}{Background mutation rate from H into R allele}

\item{d3}{Background mutation rate from E into R allele}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an ECHACR construct, it has 5 alleles at the first locus
and 4 alleles at the second.
\itemize{
\item W: Wild-type
\item H: Homing allele
\item E: Eraser allele
\item R: No-cost resistance allele
\item B: Detrimental resistance allele
\item cHW: Rate of homing from H, W -> H transition
\item cEH: Rate of homing from E, H -> E transition
\item cEW: Rate of homing from E, W -> E transition
}
}
\details{
This inheritance pattern corresponds to the Active Genetic Neutralizing Elements for Halting or Deleting Gene Drives (\doi{10.1016/j.molcel.2020.09.003}) publication.
}
