% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ASmidler.R
\name{cubeASmidler}
\alias{cubeASmidler}
\title{Inheritance Cube: Split-Drive for Andrea Smidler}
\usage{
cubeASmidler(
  cMM = 0,
  chMM = 0,
  crMM = 0,
  cPM = 0,
  chPM = 0,
  crPM = 0,
  cMF = 0,
  chMF = 0,
  crMF = 0,
  cPF = 0,
  chPF = 0,
  crPF = 0,
  crF = 0.5,
  crM = 0.5,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cMM}{Cutting efficacy of maternally-inherited Cas9 in males}

\item{chMM}{Homing efficacy of maternally-inherited Cas9 in males}

\item{crMM}{Resistance rate of maternally-inherited Cas9 in males}

\item{cPM}{Cutting efficacy of paternally-inherited Cas9 in males}

\item{chPM}{Homing efficacy of paternally-inherited Cas9 in males}

\item{crPM}{Resistance rate of paternally-inherited Cas9 in males}

\item{cMF}{Cutting efficacy of maternally-inherited Cas9 in females}

\item{chMF}{Homing efficacy of maternally-inherited Cas9 in females}

\item{crMF}{Resistance rate of maternally-inherited Cas9 in females}

\item{cPF}{Cutting efficacy of paternally-inherited Cas9 in females}

\item{chPF}{Homing efficacy of paternally-inherited Cas9 in females}

\item{crPF}{Resistance rate of paternally-inherited Cas9 in females}

\item{crF}{Female crossover rate, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{crM}{Male crossover rate, 0 is completely linked, 0.5 is unlinked, 1.0 is complete divergence}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a modified split-drive construct for split-suppression drives.
This is an autosomal, 2-locus drive. The first locus contains the Cas9 allele
and the second locus has the gRNA construct. Cas9 efficacy in each sex is
dependent upon parent of inheritance.
This construct has 3 alleles at the first locus and 4 alleles at the second.
\itemize{
\item Locus 1
\itemize{
\item W: Wild-type
\item P: Paternal Cas9
\item M: Maternal Cas9
}
\item Locus 2
\itemize{
\item W: Wild-type
\item G: gRNAs
\item R: Resistant 1
\item B: Resistant 2
}
}
}
