% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{dmap}
\alias{dmap}
\title{Calculates pairwise map distances from the recombination fraction.}
\usage{
dmap(rf, mapfn = "haldane")
}
\arguments{
\item{rf}{A symmetric matrix of pairwise recombination fractions.}

\item{mapfn}{A character string specifying the map function to be 
used in calculated the distance \code{'haldane'}, \code{'kosambi'}, \code{'none'}.}
}
\value{
a symmetric matrix of pairwise map distances in the same format as the recombination matrix supplied.
}
\description{
Calculates pairwise map distances from the recombination fraction.
}
\details{
The default is the \code{'haldane'} map function \eqn{0.5\ln(1-2rf)}{0.5ln(1-2rf)}, \code{'kosambi'} returns 
\eqn{0.25\ln((1+2rf)/(1-2rf))}{0.25ln((1+2rf)/(1-2rf))} and \code{'none'} returns \eqn{rf}, the recombination fraction.
}
\examples{
lodrf<-calc.pair.rf.lod(system.file("extdata", "lgI.txt", package="MDSMap"))
mdist=dmap(lodrf$rf,mapfn="haldane")
}
