% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FR.test.R
\name{FR.test}
\alias{FR.test}
\title{Friedman-Rafsky (FR) test}
\usage{
FR.test(
  samp1,
  samp2,
  use.cosine = FALSE,
  binary = FALSE,
  binary.cutoff = 2,
  plot.MST = FALSE,
  col = c("#F0E442", "#56B4E9"),
  label.names = c("Sample 1", "Sample 2"),
  vertex.size = 5,
  edge.width = 1,
  ...
)
}
\arguments{
\item{samp1}{Numeric matrix or data frame for Sample 1. Rows are multivariate dimensions, and columns are samples. E.g. gene by cell.}

\item{samp2}{Numeric matrix or data frame for Sample 2.}

\item{use.cosine}{An option if to use cosine distance. Logical variable. By default (\code{FALSE}),
Euclidean distance is used.}

\item{binary}{An option if to use binary values. Logical variable. Default: \code{FALSE}. If \code{TRUE},
use \code{binary.cutoff} to dichotomize \code{samp1} and \code{samp2}.}

\item{binary.cutoff}{Numeric value for binary cutoff. Binary value = 1 if greater than \code{binary.cutoff}, 0 otherwise. Default: \code{2}.}

\item{plot.MST}{Boolean variable indicating if to plot the minimum spanning tree (MST). Default: \code{FALSE}.}

\item{col}{Character vector of length two for customized colors of the nodes in MST. Default: \code{c("#F0E442", "#56B4E9")}.}

\item{label.names}{Character vector of length two for customized names of the two samples. Default: \code{c("Sample 1","Sample 2")}.}

\item{vertex.size, edge.width, ...}{Additional plotting parammeters passed to \code{\link[igraph]{plot.igraph}}. Default: \code{vertex.size=5, edge.width=1}.}
}
\value{
Test statistics and p-values.
\item{runs}{Total number of subtrees.}
\item{runs.samp1}{Number of subtrees of Sample 1.}
\item{runs.samp2}{Number of subtrees of Sample 2.}
\item{stat}{The standardized FR statistic.}
\item{p.value}{P-value of the FR test.}
}
\description{
FR test is a multivariate generalization of nonparametric two-sample test. This function is an implementation
with customized options, including a visualization of the minimum spanning tree (MST).
}
