% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{get.prior}
\alias{get.prior}
\title{Get current priors from JAGS model code}
\usage{
get.prior(model)
}
\arguments{
\item{model}{A character object of JAGS MBNMA model code}
}
\value{
A character vector, each element of which is a line of JAGS code
corresponding to a prior in the JAGS code.
}
\description{
Identical to \code{get.prior()} in \code{MBNMAtime} package.
This function takes JAGS model presented as a string and identifies what
prior values have been used for calculation.
}
\details{
Even if an MBNMA model that has not initialised successfully and
results have not been calculated, the JAGS model for it is saved in
\code{mbnma$model.arg$jagscode} and therefore priors can still be obtained.
This allows for priors to be changed even in failing models, which may help
solve issues with compiling or updating.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

# Run an Emax dose-response MBNMA
result <- mbnma.run(network, fun=demax(), method="random")

# Obtain model prior values
print(result$model.arg$priors)

# Priors when using mbnma.run with an exponential function
result <- mbnma.run(network, fun=dexp(), method="random")
print(result$model.arg$priors)
}

}
