% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikertEZ.R
\name{summarize}
\alias{summarize}
\title{Summarize a Likert item}
\usage{
summarize(responses, max_scale = 5, exact = TRUE, B = 10000, tidy = FALSE)
}
\arguments{
\item{responses}{Numeric vector of responses.}

\item{max_scale}{The maximum scale value.}

\item{exact}{If TRUE, use exact Monte Carlo method.}

\item{B}{Number of simulations for Monte Carlo.}

\item{tidy}{If TRUE, returns a tidy data frame.}
}
\value{
A list or data.frame with summary statistics.
}
\description{
This function calculates summary statistics for a Likert item, including
mean, median, mode, and performs a chi-square test.
}
\examples{
responses <- c(1, 2, 3, 4, 5, 4, 3, 2, NA)
summarize(responses)
}
