% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{style_time}
\alias{style_time}
\title{Style (date)times as times}
\usage{
style_time(x, format = "\%H:\%M")
}
\arguments{
\item{x}{a \code{numeric} vector to be styled}

\item{format}{output format. Defaults to "\%H:\%M", which results in, e.g., "03:45". Look to \code{\link[base:strptime]{base::strptime()}} for formatting options.}
}
\value{
a \code{character} vector of length(x)
}
\description{
This function takes a numeric input vector, converts them to an \code{hms} (using
\code{\link[hms:hms]{hms::as_hms()}}), then to a \code{POSIXlt} (using \code{\link[base:as.POSIXlt]{base::as.POSIXlt()}}), and then
formats is according to the \code{format} argument.
}
\examples{
#collect some time info
time <- 
sample.data.irregular |> 
dplyr::slice(300:305) |> 
dplyr::pull(Datetime)

#Output is of type POSIXct
time

time |> style_time()
}
