% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_sense_spectrogram.R
\name{brain_sense_spectrogram}
\alias{brain_sense_spectrogram}
\title{Plot BrainSense Spectrograms and Return Data (with Optional Band Filtering)}
\usage{
brain_sense_spectrogram(
  dataset = NULL,
  wl = 512,
  ovlp = 75,
  collevels = seq(-80, 0, by = 0.2),
  save_as = NULL,
  output_dir = getwd(),
  passes = NULL,
  band = NULL
)
}
\arguments{
\item{dataset}{A JSON-like object (e.g., parsed with \code{jsonlite::fromJSON()}) containing Medtronic BrainSense data. If NULL, attempts to load the default dataset from the LeadSense package.}

\item{wl}{Integer. Window length for FFT. Default is 512.}

\item{ovlp}{Numeric. Overlap percentage between successive windows. Default is 75.}

\item{collevels}{Numeric. A sequence of color levels for the spectrogram image (in dB). Default is \code{seq(-80, 0, by = 0.2)}.}

\item{save_as}{Character. File format to save plots ("png", "pdf", or "jpeg"). If NULL (default), plots are not saved.}

\item{output_dir}{Character. Path to the directory where plots will be saved. Default is current working directory.}

\item{passes}{Integer vector. Indices of passes to plot (e.g., \code{c(1,3)}). Default is NULL, which plots all available passes.}

\item{band}{Character. One of "Delta", "Theta", "Alpha", "Beta", "Gamma". If provided, filters signal to this frequency band before generating the spectrogram.}
}
\value{
A list of data frames (invisible). Each data frame corresponds to one spectrogram and contains:
\describe{
\item{time}{Time in seconds}
\item{frequency}{Frequency in Hz}
\item{magnitude}{Spectral power in dB}
\item{channel}{Channel label}
\item{pass}{Pass index (i)}
}
}
\description{
This function generates spectrograms for Medtronic BrainSense time-domain signals across one or more data passes.
Optionally, the user can select specific passes to plot, filter by frequency band, save the plots, and extract the underlying spectrogram data.
}
\details{
\strong{WARNING:} This function may be computationally intensive and take significant time to execute. Please wait until all plots are rendered.
}
\examples{
brain_sense_spectrogram(dataset, passes = c(2), band = "Beta")
}
