% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{tau}
\alias{tau}
\title{Atmospheric transmittance calculation}
\usage{
tau(To = To, RH = To, band = band)
}
\arguments{
\item{To}{Near-surface air temperature (°C) of the date when Landsat passed over the study area}

\item{RH}{relative humidity (\%) of the date when Landsat passed over the study area}

\item{band}{A string specifying which Landsat 8 thermal band to use. It can be "band 10" or
"band 11"}
}
\value{
Atmospheric transmittance
}
\description{
This function calculates Atmospheric transmittance from near-surface air temperature (To, °C) and relative humidity (RH, \%) of the date when Landsat passed over the study area
}
\examples{
tau(To = 26, RH = 42, band = "band 11")
}
