% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{E_Sobrino}
\alias{E_Sobrino}
\title{Land Surface Emissivity according to Sobrino et al. 2008}
\usage{
E_Sobrino(red = red, NDVI = NDVI)
}
\arguments{
\item{red}{SpatRaster object, red band of remote sensing imagery}

\item{NDVI}{SpatRaster object, NDVI calculated from remote sensing imagery}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Emissivity according to Sobrino et al. 2008
}
\examples{
red <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(red) = runif(10000, min=0.1, max=0.4)
NDVI <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_Sobrino(red = red, NDVI = NDVI)
}
\references{
Sobrino, J.A., Jiménez-Muñoz, J.C., Sòria, G., Romaguera, M., Guanter, L., Moreno, J., Plaza, A. and Martínez, P., 2008. Land surface emissivity retrieval from different VNIR and TIR sensors. IEEE transactions on geoscience and remote sensing, 46(2), pp.316-327.
}
