#'
#' Print LSTM Results
#'
#' @description
#' This function prints the number of factors suggested by the LSTM.
#' @seealso \code{\link[LSTMfactors]{LSTM}}
#'
#' @param x An object of class \code{LSTM}, representing the results to be printed.
#' @param ... Additional arguments to be passed to the plotting function.
#' @return None. This function is used for side effects (printing).
#'
#' @export
print.LSTM <- function(x, ...) {
  obj <- x
  cat("The number of factors suggested by ", "LSTM", " is", obj$nfact, ".\n")
}
