% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICcusumchart2.R
\name{plot_GICC_chart2}
\alias{plot_GICC_chart2}
\title{CUSUM Control Chart for Gamma Distribution with Guaranteed Performance}
\usage{
plot_GICC_chart2(
  alpha,
  beta,
  beta_ratio_plus,
  beta_ratio_minus,
  H_delta_plus,
  H_plus,
  H_delta_minus,
  H_minus,
  n_I,
  n_II,
  faseI = NULL,
  faseII = NULL,
  known_alpha
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio_plus}{Ratio between beta and its estimation for upward detection.}

\item{beta_ratio_minus}{Ratio between beta and its estimation for downward detection.}

\item{H_delta_plus}{Increment of the upper GIC limit.}

\item{H_plus}{Initial upper limit of the CUSUM chart.}

\item{H_delta_minus}{Increment of the lower GIC limit.}

\item{H_minus}{Initial lower limit of the CUSUM chart.}

\item{n_I}{Sample size in Phase I (if \code{faseI} is not provided).}

\item{n_II}{Sample size in Phase II (if \code{faseII} is not provided).}

\item{faseI}{Sample data from Phase I (numeric vector). If \code{NULL}, it is generated with \code{rgamma()}.}

\item{faseII}{Sample data from Phase II (numeric vector). If \code{NULL}, it is generated with \code{rgamma()}.}

\item{known_alpha}{If \code{TRUE}, a known \code{alpha} is used; if \code{FALSE}, it is estimated.}
}
\value{
A plot showing the evolution of the CUSUM statistic for a Gamma distribution with guaranteed performance, including:
\itemize{
\item The accumulated values of the CUSUM statistic.
\item Control limits with guaranteed performance.
\item A summary of the parameters used in the control chart.
}
}
\description{
This function generates a bidirectional (upward and downward) CUSUM control chart for a Gamma distribution,
allowing the monitoring of the evolution of the CUSUM statistic while ensuring optimal performance in detecting process changes.

Based on the methodology proposed by Madrid‐Alvarez, García‐Díaz, and Tercero‐Gómez (2024), this implementation employs a Monte Carlo-based approach
to estimate the Gamma distribution parameters and determine control limits with precise calibration.
The function enables visualization of process evolution and the detection of deviations with reduced risk of false alarms.
\subsection{Features:}{
\itemize{
\item Implements Monte Carlo simulations for control chart calibration.
\item Allows the use of known Gamma distribution values or estimation in Phase I.
\item Provides a graphical representation of the CUSUM statistic evolution with guaranteed performance.
\item Includes control limits and a legend with key configuration details of the control chart.
}

For additional details on selecting parameters \code{H_plus}, \code{H_minus}, \code{H_delta_plus}, and
\code{H_delta_minus}, as well as calibration strategies, it is recommended to consult the reference article:

\strong{Madrid‐Alvarez, H. M., García‐Díaz, J. C., & Tercero‐Gómez, V. G. (2024).}
\emph{A CUSUM control chart for gamma distribution with guaranteed performance.}
Quality and Reliability Engineering International, 40(3), 1279-1301.
}
}
\examples{
# Option 1: Automatically generate data with predefined sample sizes
plot_GICC_chart2(alpha = 1, beta = 1, beta_ratio_plus = 2,
                      beta_ratio_minus = 0.5,H_delta_plus = 2.0,
                      H_plus = 5.0, H_delta_minus = 1.5, H_minus = -4.5,
                      n_I = 100, n_II = 200, faseI = NULL,
                      faseII = NULL, known_alpha = TRUE
                     )

# Option 2: Use custom data
phaseI_data <- rgamma(n = 100, shape = 1, scale = 1)
phaseII_data <- rgamma(n = 200, shape = 1, scale = 1)
plot_GICC_chart2(alpha = 1, beta = 1, beta_ratio_plus = 2,
                 beta_ratio_minus = 0.5, H_delta_plus = 2.0, H_plus = 5.0,
                 H_delta_minus = 1.5, H_minus = -4.5, n_I = 100, n_II = 200,
                 faseI = phaseI_data, faseII = phaseII_data,
                 known_alpha = TRUE
                 )

}
