% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_abc_network}
\alias{visualize_abc_network}
\alias{vis_abc_network}
\title{Visualize ABC model results as a network}
\usage{
vis_abc_network(
  abc_results,
  top_n = 25,
  min_score = 0.1,
  node_size_factor = 3,
  edge_width_factor = 1,
  color_by = "type",
  title = "ABC Model Network"
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results from apply_abc_model().}

\item{top_n}{Number of top results to visualize.}

\item{min_score}{Minimum score threshold for including connections.}

\item{node_size_factor}{Factor for scaling node sizes.}

\item{edge_width_factor}{Factor for scaling edge widths.}

\item{color_by}{Column to use for node colors. Default is 'type'.}

\item{title}{Plot title.}
}
\value{
NULL invisibly. The function creates a plot as a side effect.
}
\description{
Create a network visualization of ABC connections using base R graphics.
}
