% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadMap.R
\name{loadMap}
\alias{loadMap}
\title{Load genetic map}
\usage{
loadMap(path)
}
\arguments{
\item{path}{Path to a map file, which should contain columns \code{Marker}, \code{Chr},
\code{cM}. (Slight variations are allowed.)}
}
\value{
A data frame.
}
\description{
Load genetic map
}
\examples{
tmp = tempfile(fileext = ".map")
map1 = as.data.frame(norSTR::map50)
write.table(map1, tmp, sep = "\t", quote = FALSE, row.names = FALSE)

map2 = loadMap(tmp)
stopifnot(all.equal(map1, map2))

}
