% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jmrmlB.R
\name{plot.jmrmlB}
\alias{plot.jmrmlB}
\title{Prediction plot from \code{jmrmlB()}}
\usage{
\method{plot}{jmrmlB}(x, y, ...)
}
\arguments{
\item{x}{fitted model object}

\item{y}{newdata}

\item{...}{others}
}
\value{
Returns prediction plot for the newdata using the model fitted through \code{jmrmlB()}.
}
\description{
Prediction plot from \code{jmrmlB()}
}
\note{
In the example code we use newdata as the data for ID 2 in the PBC2 dataset, it has follow up information till
8.832. Now suppose we want to look at the survival of ID 2 under joint model
1 after time 4 and for joint model 2 after time 9. For that we created the
newdata as if the individual is followed till for a time period
less than min(4,9).
}
\examples{
 \donttest{
##
library(JMbayes2)
library(joineRML)
jmrmlBModel<-jmrmlB(dtlong=new_long2[new_long2$id<=400,],
                    dtsurv=new_surv2[new_surv2$id<=400,],
                    longm=list(y~x7+visit,y~x7+visit),
                    survm=list(Surv(time,status)~x1+visit,
                               Surv(time_2,status_2)~x1+visit),
                    rd=list(~visit|id,~visit|id),
                    id='id',
                    timeVar='visit',
                    samplesize=200,
                    BIGdata=TRUE)
t0<-6
ndBIG<-new_long2[new_long2$id==10,]
ndBIG<-ndBIG[ndBIG$visit<t0,]
ndBIG$status<-0
ndBIG$time<-t0
ndBIG$time_2<-10
ndBIG$status_2<-0
plot(jmrmlBModel,ndBIG)
##
}
}
