% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_india_gdp.R
\name{get_india_gdp}
\alias{get_india_gdp}
\title{Get India's GDP (current US$) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/NY.GDP.MKTP.CD}
}
\usage{
get_india_gdp()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "GDP (current US$)")
  \item \code{country}: Country name ("India")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: GDP in current US dollars (numeric)
  \item \code{value_label}: GDP formatted with comma separators
}
}
\description{
Retrieves India's Gross Domestic Product (GDP) at current US dollars
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{NY.GDP.MKTP.CD}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_india_gdp()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}, \code{\link[scales]{comma}}
}
