% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{IPLCricket_tbl_df}
\alias{IPLCricket_tbl_df}
\title{Cricket data set for different seasons of Indian Premier League}
\format{
A tibble with 8,560 observations and 10 variables:
\describe{
  \item{season}{Season year of the IPL (numeric)}
  \item{match_id}{Unique match identifier (numeric)}
  \item{batting_team}{Name of the batting team (character)}
  \item{bowling_team}{Name of the bowling team (character)}
  \item{inning}{Inning number (numeric)}
  \item{over}{Over number (numeric)}
  \item{wicket}{Number of wickets taken in the over (numeric)}
  \item{dot_balls}{Number of dot balls in the over (numeric)}
  \item{runs_per_over}{Runs scored in the over (numeric)}
  \item{run_rate}{Run rate for the over (numeric)}
}
}
\source{
Data taken from the \pkg{gravitas} package version 0.1.3
}
\usage{
data(IPLCricket_tbl_df)
}
\description{
This dataset, IPLCricket_tbl_df, is a tibble containing match data from the Indian Premier League (IPL)
played by teams representing different cities in India from 2008 to 2016.
}
\details{
The dataset name has been kept as 'IPLCricket_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
IndiAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
