% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.Hmsc}
\alias{predict.Hmsc}
\title{predict}
\usage{
\method{predict}{Hmsc}(
  object,
  post = poolMcmcChains(object$postList),
  Loff = NULL,
  XData = NULL,
  X = NULL,
  XRRRData = NULL,
  XRRR = NULL,
  studyDesign = object$studyDesign,
  ranLevels = object$ranLevels,
  Gradient = NULL,
  Yc = NULL,
  mcmcStep = 1,
  expected = FALSE,
  predictEtaMean = FALSE,
  predictEtaMeanField = FALSE,
  nParallel = 1,
  useSocket = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted \code{Hmsc} model object}

\item{post}{a list of posterior samples of the HMSC model. By default uses all samples from the pooled
posterior of the hM object.}

\item{Loff}{offset matrix of the same dimensions as the prediction. Added to the predictions on the linear predictor scale.
Same as in the \code{Hmsc} constructor, this is used to account to pre-defined differences between prediction units.}

\item{XData}{a dataframe specifying the unpreprocessed covariates for the predictions to be made.
Works only if the \code{XFormula} argument was specified in the \code{Hmsc()} model constructor call.
Requirements are similar to those in the \code{Hmsc} model constructor.}

\item{X}{a matrix specifying the covariates for the predictions to be made.
Only one of XData and X arguments may be provided.}

\item{XRRRData}{a dataframe of covariates for reduced-rank regression}

\item{XRRR}{a matrix of covariates for reduced-rank regression}

\item{studyDesign}{a matrix, specifying the structure of the study design for the prediction.
Requirements are similar to those of the \code{Hmsc} constructor. By default this argument is
assigned the study design of the training data in the fitted Hmsc model.}

\item{ranLevels}{a list of \code{HmscRandomLevel} objects, futher specifying the structure of
random levels. Requirements are similar to those of the \code{Hmsc} constructor.
Each level must cover all units, specified in the correspondingly named column of \code{studyDesign}
argument. By default this argument is assigned the list of \code{HmscRandomLevel} objects
specified for fitting Hmsc model.}

\item{Gradient}{an object returned by
\code{\link{constructGradient}}. Providing \code{Gradient} is
an alternative for providing \code{XData}, \code{studyDesign}
and \code{ranLevels}. Cannot be used together with \code{Yc}.}

\item{Yc}{a matrix of the outcomes that are assumed to be known for
conditional predictions. Cannot be used together with
\code{Gradient} and use with caution for spatial models (see details).}

\item{mcmcStep}{the number of extra mcmc steps used for updating the random effects}

\item{expected}{boolean flag indicating whether to return the location parameter of the observation
models or sample the values from those.}

\item{predictEtaMean}{boolean flag indicating whether to use the estimated mean values of posterior
predictive distribution for random effets corresponding for the new units.}

\item{predictEtaMeanField}{boolean flag indicating whether to use draws from the mean-field of the
posterior predictive distribution for random effets corresponding for the new units.}

\item{nParallel}{Number of parallel processes. Parallel processing
is only useful with new \code{Yc} data and extra
\code{mcmcStep}.}

\item{useSocket}{(logical) Use socket clusters in parallel
proecessing; these are the only alternative in Windows, but in
other systems this should be usually set \code{FALSE} for
forking.}

\item{\dots}{other arguments passed to functions.}
}
\value{
A list of length \code{length(post)}, each element of which contains a sample from the posterior
predictive distribution (given the sample of the Hmsc model parameters in the corresponding element of
the \code{post} argument)
}
\description{
Calculates predicted values from a fitted \code{Hmsc} model.
}
\details{
In case of conditional predictions (once non null \code{Yc} is provided)
\code{mcmcStep},the number of extra mcmc steps used for updating the random effects
for the Eta parameters, starting from the samples of the fitted Hmsc model in order to
account for the conditional infromation provided in the Yc argument. The higher this number is,
the more the obtained updated samples are unaffected by the posterior estimates of latent factors
in the model fitted to the training data and more resembles the true conditional posterior. However,
the elapsed time for conditional prediction grows approximately linearly as this parameter increases.
The exact number for sufficient is problem-dependent and should be assessed by e.g. gradually
increasing this parameter till the stationarity of the produced predictions.

Note that the currently implemented conditional predictions behavior is well-formulated once the sampling units in
\code{Yc} are either the same as in the originally fitted model \code{Y}, or are considered independent of those.
Thus, if seeking such conditional predictions at new loacations for a spatial \code{Hmsc} model,
or the case once some units of \code{HmscRandomLevel} belong both to the training and predictions sets of sampling units,
the current implementations is not guaranteed to correctly operate in intended way.
}
\seealso{
\code{\link{predictLatentFactor}}
}
