% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiGarrote.R
\name{predict.nnGarrote}
\alias{predict.nnGarrote}
\title{Make Predictions from a "nnGarrote" Object}
\usage{
\method{predict}{nnGarrote}(object, new_X, ...)
}
\arguments{
\item{object}{An \code{nnGarrote} object.}

\item{new_X}{A new input matrix where predictions are to be made.}

\item{...}{Additional arguments passed to `predict`. Not used in this function.}
}
\value{
The function returns a list with:
\describe{
\item{\code{new_U}}{A model matrix of \code{new_X}.}
\item{\code{prediction_nng}}{Predictions for \code{new_X}. The coefficients of the predictive equation are based on nonnegative garrote estimates.}
\item{\code{prediction_lm}}{Predictions for \code{new_X}. The coefficients of the predictive equation are estimated via ordinary least squares.}
}
}
\description{
This function makes predictions from a linear model constructed using the important effects selected by \code{nnGarrote}.
}
\examples{
# Generate data
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
error <- rnorm(100)
X <- data.frame(x1, x2, x3)
U <- model.matrix(~. + x1:x2 + x1:x3 + x2:x3 + I(x1^2) + I(x2^2) + I(x3^2) - 1, X)
U <- data.frame(scale(U))
colnames(U) <- c("x1", "x2", "x3", "x1:x1", "x2:x2", "x3:x3", "x1:x2", "x1:x3", "x2:x3")
y <- 3 + 3*U$x1 + 3*U$`x1:x1` + 3*U$`x1:x2`+ 3*U$`x1:x3` + error

# training and testing set
train_idx <- sample(1:100, 80)
X_train <- X[train_idx,]
y_train <- y[train_idx]
X_test <- X[-train_idx,]
y_test <- y[-train_idx]

# fit nnGarrote
fit_nng <- HiGarrote::nnGarrote(X_train, y_train)

# predict
pred_nng <- predict(fit_nng, X_test)
}
