% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smplSizPredModel.R
\name{smplSizPredModel}
\alias{smplSizPredModel}
\title{Generate a Linear Model for Sample Size Prediction}
\usage{
smplSizPredModel(
  df4model = df4modelInpt,
  heritabilityClass,
  inptPwr,
  fc,
  trait = NULL,
  tissue = NULL
)
}
\arguments{
\item{df4model}{A data frame containing the input data for the model. It should include the following columns: \code{NoOfReplicates}, \code{HeritabilityValue}, \code{pwr}, \code{FoldChange}, and optionally, \code{Tissue}.}

\item{heritabilityClass}{A character value indicating the class of heritability used for filtering the data.}

\item{inptPwr}{A numeric value representing the power used in the model.}

\item{fc}{A numeric value representing the fold change used in the model.}

\item{trait}{An optional parameter to specify the trait. If provided, it can be used for further filtering, but it's not currently used in the function.}

\item{tissue}{An optional parameter specifying the tissue type. If provided, the model will include the tissue information in the regression. If not provided, the model will exclude tissue information.}
}
\value{
A linear model object (\code{lm} class), which contains the fitted linear regression model for the number of replicates prediction.
}
\description{
This function generates a linear regression model to predict the number of replicates (\code{NoOfReplicates}) based on heritability, power, fold change, and tissue type. The model is generated depending on whether the tissue information is provided in the data. The function returns the fitted model.
}
\examples{
\donttest{
# Example usage:
df4modelInpt <- data.frame(
    NoOfReplicates = c(3, 5, 7, 9, 11),
    HeritabilityClass = c("high", "mid", "low", "high", "mid"),
    HeritabilityValue = c(0.5, 0.6, 0.7, 0.5, 0.6),
    pwr = c(0.8, 0.9, 0.85, 0.88, 0.86),
    FoldChange = c(2, 3, 2.5, 2.8, 3.2),
    Tissue = c("Liver", "Liver", "Kidney", "Liver", "Kidney")
)

# Fit the model
model <- smplSizPredModel(
    df4model = df4modelInpt,
    heritabilityClass = "high",
    inptPwr = 0.8,
    fc = 2,
    tissue = "Liver"
)

# Summarize the results
summary(model)
}

}
\references{
Sun et al. (2017) \doi{10.1093/nar/gkx204}
}
